/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.dcm4che.data.Command;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmHandler;
import org.dcm4che.data.DcmValueException;
import org.dcm4cheri.data.DcmObjectImpl;
import org.dcm4cheri.data.DcmParserImpl;
import org.dcm4cheri.data.DcmStreamHandlerImpl;

final class CommandImpl
extends DcmObjectImpl
implements Command {
    private int cmdField = -1;
    private int dataSetType = -1;
    private int status = -1;
    private int msgID = -1;
    private String sopClassUID = null;
    private String sopInstUID = null;

    CommandImpl() {
    }

    public int getCommandField() {
        return this.cmdField;
    }

    public int getMessageID() {
        return this.msgID;
    }

    public int getMessageIDToBeingRespondedTo() {
        return this.msgID;
    }

    public String getAffectedSOPClassUID() {
        return this.sopClassUID;
    }

    public String getRequestedSOPClassUID() {
        return this.sopClassUID;
    }

    public String getAffectedSOPInstanceUID() {
        return this.sopInstUID;
    }

    public String getRequestedSOPInstanceUID() {
        return this.sopInstUID;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isPending() {
        switch (this.status) {
            case 65280: 
            case 65281: {
                return true;
            }
        }
        return false;
    }

    public boolean isRequest() {
        switch (this.cmdField) {
            case 1: 
            case 16: 
            case 32: 
            case 33: 
            case 48: 
            case 256: 
            case 272: 
            case 288: 
            case 304: 
            case 320: 
            case 336: 
            case 65535: {
                return true;
            }
        }
        return false;
    }

    public boolean isResponse() {
        switch (this.cmdField) {
            case 32769: 
            case 32784: 
            case 32800: 
            case 32801: 
            case 32816: 
            case 33024: 
            case 33040: 
            case 33056: 
            case 33072: 
            case 33088: 
            case 33104: {
                return true;
            }
        }
        return false;
    }

    public boolean hasDataset() {
        if (this.dataSetType == -1) {
            throw new IllegalStateException();
        }
        return this.dataSetType != 257;
    }

    private Command initCxxxxRQ(int n, int n2, String string, int n3) {
        if (n3 != 0 && n3 != 1 && n3 != 2) {
            throw new IllegalArgumentException("priority=" + n3);
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.putUI(2, string);
        this.putUS(256, n);
        this.putUS(272, n2);
        this.putUS(1792, n3);
        return this;
    }

    private Command initCxxxxRSP(int n, int n2, String string, int n3) {
        if (string != null) {
            this.putUI(2, string);
        }
        this.putUS(256, n);
        this.putUS(288, n2);
        this.putUS(2304, n3);
        return this;
    }

    public Command initCStoreRQ(int n, String string, String string2, int n2) {
        if (string2.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.initCxxxxRQ(1, n, string, n2);
        this.putUI(4096, string2);
        return this;
    }

    public Command setMoveOriginator(String string, int n) {
        if (string.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.putAE(4144, string);
        this.putUS(4145, n);
        return this;
    }

    public Command initCStoreRSP(int n, String string, String string2, int n2) {
        return this.initNxxxxRSP(32769, n, string, string2, n2);
    }

    public Command initCFindRQ(int n, String string, int n2) {
        return this.initCxxxxRQ(32, n, string, n2);
    }

    public Command initCFindRSP(int n, String string, int n2) {
        return this.initCxxxxRSP(32800, n, string, n2);
    }

    public Command initCCancelRQ(int n) {
        this.putUS(256, 65535);
        this.putUS(288, n);
        return this;
    }

    public Command initCGetRQ(int n, String string, int n2) {
        return this.initCxxxxRQ(16, n, string, n2);
    }

    public Command initCGetRSP(int n, String string, int n2) {
        return this.initCxxxxRSP(32784, n, string, n2);
    }

    public Command initCMoveRQ(int n, String string, int n2, String string2) {
        if (string2.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.initCxxxxRQ(33, n, string, n2);
        this.putAE(1536, string2);
        return this;
    }

    public Command initCMoveRSP(int n, String string, int n2) {
        return this.initCxxxxRSP(32801, n, string, n2);
    }

    public Command initCEchoRQ(int n, String string) {
        if (string.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.putUI(2, string);
        this.putUS(256, 48);
        this.putUS(272, n);
        return this;
    }

    public Command initCEchoRQ(int n) {
        return this.initCEchoRQ(n, "1.2.840.10008.1.1");
    }

    public Command initCEchoRSP(int n, String string, int n2) {
        return this.initCxxxxRSP(32816, n, string, n2);
    }

    public Command initCEchoRSP(int n) {
        return this.initCxxxxRSP(32816, n, "1.2.840.10008.1.1", 0);
    }

    private Command initNxxxxRQ(int n, int n2, String string, String string2) {
        if (string.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (string2.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.putUI(3, string);
        this.putUS(256, n);
        this.putUS(272, n2);
        this.putUI(4097, string2);
        return this;
    }

    private Command initNxxxxRSP(int n, int n2, String string, String string2, int n3) {
        if (string != null) {
            this.putUI(2, string);
        }
        this.putUS(256, n);
        this.putUS(288, n2);
        this.putUS(2304, n3);
        if (string2 != null) {
            this.putUI(4096, string2);
        }
        return this;
    }

    public Command initNEventReportRQ(int n, String string, String string2, int n2) {
        if (string.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (string2.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.putUI(2, string);
        this.putUS(256, 256);
        this.putUS(272, n);
        this.putUI(4096, string2);
        this.putUS(4098, n2);
        return this;
    }

    public Command initNEventReportRSP(int n, String string, String string2, int n2) {
        return this.initNxxxxRSP(33024, n, string, string2, n2);
    }

    public Command initNGetRQ(int n, String string, String string2, int[] nArray) {
        this.initNxxxxRQ(272, n, string, string2);
        if (nArray != null) {
            this.putAT(4101, nArray);
        }
        return this;
    }

    public Command initNGetRSP(int n, String string, String string2, int n2) {
        return this.initNxxxxRSP(33040, n, string, string2, n2);
    }

    public Command initNSetRQ(int n, String string, String string2) {
        return this.initNxxxxRQ(288, n, string, string2);
    }

    public Command initNSetRSP(int n, String string, String string2, int n2) {
        return this.initNxxxxRSP(33056, n, string, string2, n2);
    }

    public Command initNActionRQ(int n, String string, String string2, int n2) {
        this.initNxxxxRQ(304, n, string, string2);
        this.putUS(4104, n2);
        return this;
    }

    public Command initNActionRSP(int n, String string, String string2, int n2) {
        return this.initNxxxxRSP(33072, n, string, string2, n2);
    }

    public Command initNCreateRQ(int n, String string, String string2) {
        if (string.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.putUI(2, string);
        this.putUS(256, 320);
        this.putUS(272, n);
        if (string2 != null) {
            this.putUI(4096, string2);
        }
        return this;
    }

    public Command initNCreateRSP(int n, String string, String string2, int n2) {
        return this.initNxxxxRSP(33088, n, string, string2, n2);
    }

    public Command initNDeleteRQ(int n, String string, String string2) {
        return this.initNxxxxRQ(336, n, string, string2);
    }

    public Command initNDeleteRSP(int n, String string, String string2, int n2) {
        return this.initNxxxxRSP(33104, n, string, string2, n2);
    }

    protected DcmElement put(DcmElement dcmElement) {
        int n = dcmElement.tag();
        if ((n & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException(dcmElement.toString());
        }
        try {
            switch (n) {
                case 2: 
                case 3: {
                    this.sopClassUID = dcmElement.getString(null);
                    break;
                }
                case 256: {
                    this.cmdField = dcmElement.getInt();
                    break;
                }
                case 272: 
                case 288: {
                    this.msgID = dcmElement.getInt();
                    break;
                }
                case 2048: {
                    this.dataSetType = dcmElement.getInt();
                    break;
                }
                case 2304: {
                    this.status = dcmElement.getInt();
                    break;
                }
                case 4096: 
                case 4097: {
                    this.sopInstUID = dcmElement.getString(null);
                }
            }
        }
        catch (DcmValueException dcmValueException) {
            throw new IllegalArgumentException(dcmElement.toString());
        }
        return super.put(dcmElement);
    }

    public int length() {
        return this.grLen() + 12;
    }

    private int grLen() {
        int n = 0;
        int n2 = 0;
        int n3 = this.list.size();
        while (n2 < n3) {
            n += ((DcmElement)this.list.get(n2)).length() + 8;
            ++n2;
        }
        return n;
    }

    public void write(DcmHandler dcmHandler) throws IOException {
        dcmHandler.setDcmDecodeParam(DcmDecodeParam.IVR_LE);
        this.write(0, this.grLen(), dcmHandler);
    }

    public void write(OutputStream outputStream) throws IOException {
        this.write(new DcmStreamHandlerImpl(outputStream));
    }

    public void read(InputStream inputStream) throws IOException {
        DcmParserImpl dcmParserImpl = new DcmParserImpl(inputStream);
        dcmParserImpl.setDcmHandler(this.getDcmHandler());
        dcmParserImpl.parseCommand();
    }

    public String toString() {
        return this.toStringBuffer(new StringBuffer()).toString();
    }

    private StringBuffer toStringBuffer(StringBuffer stringBuffer) {
        stringBuffer.append(this.msgID).append(':').append(this.cmdFieldAsString());
        if (this.dataSetType != 257) {
            stringBuffer.append(" with Dataset");
        }
        if (this.sopClassUID != null) {
            stringBuffer.append("\n\tclass:\t").append(DcmObjectImpl.DICT.lookup(this.sopClassUID));
        }
        if (this.sopInstUID != null) {
            stringBuffer.append("\n\tinst:\t").append(DcmObjectImpl.DICT.lookup(this.sopInstUID));
        }
        if (this.status != -1) {
            stringBuffer.append("\n\tstatus:\t").append(Integer.toHexString(this.status));
        }
        return stringBuffer;
    }

    private String cmdFieldAsString() {
        switch (this.cmdField) {
            case 1: {
                return "C_STORE_RQ";
            }
            case 16: {
                return "C_GET_RQ";
            }
            case 32: {
                return "C_FIND_RQ";
            }
            case 33: {
                return "C_MOVE_RQ";
            }
            case 48: {
                return "C_ECHO_RQ";
            }
            case 256: {
                return "N_EVENT_REPORT_RQ";
            }
            case 272: {
                return "N_GET_RQ";
            }
            case 288: {
                return "N_SET_RQ";
            }
            case 304: {
                return "N_ACTION_RQ";
            }
            case 320: {
                return "N_CREATE_RQ";
            }
            case 336: {
                return "N_DELETE_RQ";
            }
            case 65535: {
                return "C_CANCEL_RQ";
            }
            case 32769: {
                return "C_STORE_RSP";
            }
            case 32784: {
                return "C_GET_RSP";
            }
            case 32800: {
                return "C_FIND_RSP";
            }
            case 32801: {
                return "C_MOVE_RSP";
            }
            case 32816: {
                return "C_ECHO_RSP";
            }
            case 33024: {
                return "N_EVENT_REPORT_RSP";
            }
            case 33040: {
                return "N_GET_RSP";
            }
            case 33056: {
                return "N_SET_RSP";
            }
            case 33072: {
                return "N_ACTION_RSP";
            }
            case 33088: {
                return "N_CREATE_RSP";
            }
            case 33104: {
                return "N_DELETE_RSP";
            }
        }
        return "cmd:" + Integer.toHexString(this.cmdField);
    }
}

