/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.zip.DeflaterOutputStream;
import javax.imageio.stream.ImageOutputStream;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DatasetSerializer;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmEncodeParam;
import org.dcm4che.data.DcmHandler;
import org.dcm4che.data.FileMetaInfo;
import org.dcm4che.dict.TagDictionary;
import org.dcm4che.dict.VRs;
import org.dcm4cheri.data.DcmHandlerAdapter;
import org.dcm4cheri.data.DcmObjectImpl;
import org.dcm4cheri.data.DcmStreamHandlerImpl;
import org.dcm4cheri.data.FilterDataset;
import org.dcm4cheri.data.FragmentElement;
import org.dcm4cheri.data.OutputStreamAdapter;
import org.dcm4cheri.data.SQElement;
import org.dcm4cheri.data.ValueElement;
import org.xml.sax.ContentHandler;

abstract class BaseDatasetImpl
extends DcmObjectImpl
implements Dataset {
    private FileMetaInfo fmi = null;
    private int[] grTags = new int[8];
    private int[] grLens = new int[8];
    private int grCount = 0;
    protected int totLen = 0;

    BaseDatasetImpl() {
    }

    public final Dataset setFileMetaInfo(FileMetaInfo fileMetaInfo) {
        this.fmi = fileMetaInfo;
        return this;
    }

    public FileMetaInfo getFileMetaInfo() {
        return this.fmi;
    }

    public String toString() {
        return "[" + this.size() + " elements]";
    }

    private int[] ensureCapacity(int[] nArray, int n) {
        if (n <= nArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[nArray.length << 1];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public int calcLength(DcmEncodeParam dcmEncodeParam) {
        this.totLen = 0;
        this.grCount = 0;
        int n = -1;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DcmElement dcmElement = (DcmElement)iterator.next();
            int n2 = dcmElement.tag() & 0xFFFF0000;
            if (n2 != n) {
                ++this.grCount;
                this.grTags = this.ensureCapacity(this.grTags, this.grCount + 1);
                this.grLens = this.ensureCapacity(this.grLens, this.grCount + 1);
                this.grTags[this.grCount - 1] = n = n2;
                this.grLens[this.grCount - 1] = 0;
            }
            int n3 = this.grCount - 1;
            this.grLens[n3] = this.grLens[n3] + (dcmEncodeParam.explicitVR && !VRs.isLengthField16Bit(dcmElement.vr()) ? 12 : 8);
            if (dcmElement instanceof ValueElement) {
                int n4 = this.grCount - 1;
                this.grLens[n4] = this.grLens[n4] + dcmElement.length();
                continue;
            }
            if (dcmElement instanceof FragmentElement) {
                int n5 = this.grCount - 1;
                this.grLens[n5] = this.grLens[n5] + ((FragmentElement)dcmElement).calcLength();
                continue;
            }
            int n6 = this.grCount - 1;
            this.grLens[n6] = this.grLens[n6] + ((SQElement)dcmElement).calcLength(dcmEncodeParam);
        }
        this.grTags[this.grCount] = -1;
        if (!dcmEncodeParam.skipGroupLen) {
            this.totLen += this.grCount * 12;
        }
        int n7 = 0;
        while (n7 < this.grCount) {
            this.totLen += this.grLens[n7];
            ++n7;
        }
        return this.totLen;
    }

    public int length() {
        return this.totLen;
    }

    public void clear() {
        super.clear();
        this.totLen = 0;
    }

    public void writeDataset(DcmHandler dcmHandler, DcmEncodeParam dcmEncodeParam) throws IOException {
        if (!(dcmEncodeParam.skipGroupLen && dcmEncodeParam.undefItemLen && dcmEncodeParam.undefSeqLen)) {
            this.calcLength(dcmEncodeParam);
        }
        dcmHandler.startDataset();
        dcmHandler.setDcmDecodeParam(dcmEncodeParam);
        this.doWrite(dcmHandler, dcmEncodeParam);
        dcmHandler.endDataset();
    }

    private void doWrite(DcmHandler dcmHandler, DcmEncodeParam dcmEncodeParam) throws IOException {
        int n = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            int n2;
            DcmElement dcmElement = (DcmElement)iterator.next();
            if (!dcmEncodeParam.skipGroupLen && this.grTags[n] == (dcmElement.tag() & 0xFFFF0000)) {
                byte[] byArray = new byte[4];
                ByteBuffer.wrap(byArray).order(dcmEncodeParam.byteOrder).putInt(this.grLens[n]);
                dcmHandler.startElement(this.grTags[n], 21836, dcmElement.getStreamPosition());
                dcmHandler.value(byArray, 0, 4);
                dcmHandler.endElement();
                ++n;
            }
            if (dcmElement instanceof SQElement) {
                int n3 = dcmEncodeParam.undefSeqLen ? -1 : dcmElement.length();
                dcmHandler.startElement(dcmElement.tag(), 21329, dcmElement.getStreamPosition());
                dcmHandler.startSequence(n3);
                int n4 = 0;
                n2 = dcmElement.vm();
                while (n4 < n2) {
                    BaseDatasetImpl baseDatasetImpl = (BaseDatasetImpl)dcmElement.getItem(n4);
                    int n5 = dcmEncodeParam.undefItemLen ? -1 : baseDatasetImpl.length();
                    dcmHandler.startItem(++n4, baseDatasetImpl.getItemOffset(), n5);
                    baseDatasetImpl.doWrite(dcmHandler, dcmEncodeParam);
                    dcmHandler.endItem(n5);
                }
                dcmHandler.endSequence(n3);
                dcmHandler.endElement();
                continue;
            }
            if (dcmElement instanceof FragmentElement) {
                long l = dcmElement.getStreamPosition();
                dcmHandler.startElement(dcmElement.tag(), dcmElement.vr(), l);
                dcmHandler.startSequence(-1);
                if (l != -1L) {
                    l += 12L;
                }
                n2 = 0;
                int n6 = dcmElement.vm();
                while (n2 < n6) {
                    ByteBuffer byteBuffer = dcmElement.getDataFragment(n2, dcmEncodeParam.byteOrder);
                    dcmHandler.fragment(++n2, l, byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit());
                    if (l == -1L) continue;
                    l += (long)(byteBuffer.limit() + 9 & 0xFFFFFFFE);
                }
                dcmHandler.endSequence(-1);
                dcmHandler.endElement();
                continue;
            }
            int n7 = dcmElement.length();
            dcmHandler.startElement(dcmElement.tag(), dcmElement.vr(), dcmElement.getStreamPosition());
            ByteBuffer byteBuffer = dcmElement.getByteBuffer(dcmEncodeParam.byteOrder);
            dcmHandler.value(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit());
            dcmHandler.endElement();
        }
    }

    public void writeDataset(OutputStream outputStream, DcmEncodeParam dcmEncodeParam) throws IOException {
        if (dcmEncodeParam == null) {
            dcmEncodeParam = DcmDecodeParam.IVR_LE;
        }
        this.writeDataset(new DcmStreamHandlerImpl(dcmEncodeParam.deflated ? new DeflaterOutputStream(outputStream) : outputStream), dcmEncodeParam);
    }

    public void writeFile(OutputStream outputStream, DcmEncodeParam dcmEncodeParam) throws IOException {
        FileMetaInfo fileMetaInfo = this.getFileMetaInfo();
        if (fileMetaInfo != null) {
            fileMetaInfo.write(outputStream);
            if (dcmEncodeParam == null) {
                dcmEncodeParam = DcmDecodeParam.valueOf(fileMetaInfo.getTransferSyntaxUID());
            }
        }
        this.writeDataset(outputStream, dcmEncodeParam);
    }

    public void writeDataset(ImageOutputStream imageOutputStream, DcmEncodeParam dcmEncodeParam) throws IOException {
        if (dcmEncodeParam == null) {
            dcmEncodeParam = DcmDecodeParam.IVR_LE;
        }
        this.writeDataset(dcmEncodeParam.deflated ? new DcmStreamHandlerImpl(new DeflaterOutputStream(new OutputStreamAdapter(imageOutputStream))) : new DcmStreamHandlerImpl(imageOutputStream), dcmEncodeParam);
    }

    public void writeFile(ImageOutputStream imageOutputStream, DcmEncodeParam dcmEncodeParam) throws IOException {
        FileMetaInfo fileMetaInfo = this.getFileMetaInfo();
        if (fileMetaInfo != null) {
            fileMetaInfo.write(imageOutputStream);
            if (dcmEncodeParam == null) {
                dcmEncodeParam = DcmDecodeParam.valueOf(fileMetaInfo.getTransferSyntaxUID());
            }
        }
        this.writeDataset(imageOutputStream, dcmEncodeParam);
    }

    public void writeDataset(ContentHandler contentHandler, TagDictionary tagDictionary) throws IOException {
        this.writeDataset(new DcmHandlerAdapter(contentHandler, tagDictionary), DcmDecodeParam.EVR_LE);
    }

    public void writeFile(ContentHandler contentHandler, TagDictionary tagDictionary) throws IOException {
        DcmHandlerAdapter dcmHandlerAdapter = new DcmHandlerAdapter(contentHandler, tagDictionary);
        dcmHandlerAdapter.startDcmFile();
        FileMetaInfo fileMetaInfo = this.getFileMetaInfo();
        if (fileMetaInfo != null) {
            fileMetaInfo.write(dcmHandlerAdapter);
        }
        this.writeDataset(dcmHandlerAdapter, DcmDecodeParam.EVR_LE);
        dcmHandlerAdapter.endDcmFile();
    }

    public Dataset subSet(int n, int n2) {
        return new FilterDataset.Segment(this, n, n2);
    }

    public Dataset subSet(Dataset dataset) {
        return new FilterDataset.Selection(this, dataset);
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new DatasetSerializer(this);
    }
}

