/* $Id: gg.h,v 1.4 2003/04/25 20:16:36 cegger Exp $
******************************************************************************
  
   LibGG - API header file
  
   Copyright (C) 1998-1999 Marcus Sundberg	[marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
   
******************************************************************************
*/

#ifndef _GGI_GG_H
#define _GGI_GG_H

#include <stdio.h>
#include <stdlib.h>
#include <ggi/errors.h>
#include <ggi/system.h>


__BEGIN_DECLS
/*
******************************************************************************
 Initialize/Deinitialize library
******************************************************************************
*/

int ggInit(void);

int ggExit(void);


/*
******************************************************************************
 Functions for adding and removing cleanup callbacks
******************************************************************************
*/

typedef void (ggcleanup_func)(void *);

int ggRegisterCleanup(ggcleanup_func *func, void *arg);

int ggUnregisterCleanup(ggcleanup_func *func, void *arg);

/* Try to force _exit() when a handler is triggered */
void ggCleanupForceExit(void);


/*
******************************************************************************
 Misc functions
******************************************************************************
*/

/* Get the users "home" directory, or whatever the equivalent is under the
   system we are running on. */
const char *ggGetUserDir(void);


/*
******************************************************************************
 Configuration file handling
******************************************************************************
*/

int ggLoadConfig(const char *file, void **confret);

void ggFreeConfig(void *conf);

const char *ggMatchConfig(const void *conf, const char *name,
			  const char *version);

int ggConfigExpandAlias(void *confhandle, const char *list_in,
			char *list_out, size_t outmax);

/*
******************************************************************************
 Dynamic module loading
******************************************************************************
*/

typedef void *gg_module;

#define GG_MODULE_NULL	NULL

#define GG_MODULE_GLOBAL 1

/* Dynamicly load file */
gg_module ggLoadModule(const char *filename, int flags);

/* Try to match name in conf and load the resulting filename */
gg_module ggMLoadModule(const void *conf, const char *name, 
			const char *version, int flags);

/* Get Address of symbol in module */
void *ggGetSymbolAddress(gg_module module, const char *symbol);

/* Unload a module and free resources */
void ggFreeModule(gg_module module);


/*
******************************************************************************
 Parsing functions
******************************************************************************
*/

/* Read the first matching option from an option file into the corresponding
   result entry */
int ggGetFileOpt(FILE *fp, const char **optnames, char **results, int ressize);

char *ggParseTarget(const char *str, char *target, int max);

#define GG_MAX_OPTION_NAME    32
#define GG_MAX_OPTION_RESULT  256

typedef struct gg_option
{
	char name[GG_MAX_OPTION_NAME];
	char result[GG_MAX_OPTION_RESULT];
} gg_option;

char *ggParseOptions(const char *str, gg_option *optlist, int count);


/*
******************************************************************************
 Debug output
******************************************************************************
*/

void ggDPrintf(int sync, const char *subsys, const char *form, ...);

/*
******************************************************************************
 Mutex locking
******************************************************************************
*/

void *ggLockCreate(void);

int ggLockDestroy(void *lock);

int ggLock(void *lock);

int ggUnlock(void *lock);

int ggTryLock(void *lock);

/*
******************************************************************************
 CPU Identification and SIMD disable/enable
******************************************************************************
*/

/* These are exclusive even between architectures to limit cpp complexity.
 * And who knows, perhaps cross-arch emulations may happen.
 */
enum gg_swartype {
	GG_SWAR_NONE	=	0x00000001, /* Vanilla C implementation */
	GG_SWAR_32BITC	=	0x00000002, /* Fast 32b math vs 16b */
	GG_SWAR_ALTIVEC	=	0x00000004,
	GG_SWAR_SSE	=	0x00000008,
	GG_SWAR_SSE2	=	0x00000010,
	GG_SWAR_MMX	=	0x00000020,
	GG_SWAR_MMXPLUS	=	0x00000040, /* Cyrix. */
	GG_SWAR_3DNOW	=	0x00000080, /* Implies MMX enhancements */
	GG_SWAR_ADV3DNOW=	0x00000100, /* Implies MMX enhancements */
	GG_SWAR_MAX	=	0x00000200,
	GG_SWAR_SIGD	=	0x00000400, /* 32b or 64b?? */

#ifdef GG_HAVE_INT64

	GG_SWAR_64BITC	=	0x0000000100000000LL, /* Fast 64b math vs 32b */
	GG_SWAR_MVI	=	0x0000000200000000LL, /* available in 32b mode?*/
	GG_SWAR_MAX2	=	0x0000000400000000LL,
	GG_SWAR_MDMX	=	0x0000000800000000LL, /* available in 32b mode?*/
	GG_SWAR_MAJC	=	0x0000001000000000LL,
	GG_SWAR_VIS	=	0x0000002000000000LL,


	GG_SWAR_ALL = 0xffffffffffffffffLL
#else
	GG_SWAR_ALL = 0xffffffff

#endif

};

enum gg_swartype ggGetSwarType(void);

__END_DECLS

#endif /* _GGI_GG_H */
